//+------------------------------------------------------------------+
//|                                                     T3 basic.mq4 |
//|                                                           mladen |
//|                                                                  |
//|                                                                  |
//| original T3 developed by Tim Tilson (TASC January 1998)          |
//| period lag modification by Bob Fulks and Alex Matulich 4/2003    |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red

//
//
//
//
//

extern int    T3Period   = 14;
extern int    T3Price    = PRICE_CLOSE;
extern double T3Hot      = 0.7;
extern bool   T3Original = true;

//
//
//
//
//

double t3[];
double emas[][6];
double alpha;
double c1;
double c2;
double c3;
double c4;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,t3);

   //
   //
   //
   //
   //
   
      double a  = T3Hot;
             c1 = -a*a*a;
             c2 = 3*a*a+3*a*a*a;
             c3 = -6*a*a-3*a-3*a*a*a;
             c4 = 1+3*a+a*a*a+3*a*a;
               
   //
   //
   //
   //
   //
               
      T3Period = MathMax(1,T3Period);
      if (T3Original)
           alpha = 2.0/(1.0 + T3Period);
      else alpha = 2.0/(2.0 + (T3Period-1.0)/2.0);
      
   IndicatorShortName("T3 ("+T3Period+")");
   return(0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
   int i,limit;

   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
           limit=Bars-counted_bars;
           if (ArrayRange(emas,0) != Bars) ArrayResize(emas,Bars);

   //
   //
   //
   //
   //

   for(i=limit; i>=0; i--) t3[i] = iT3(iMA(NULL,0,1,0,MODE_SMA,T3Price,i),i);
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

double iT3(double price,int shift)
{
   int i = Bars-shift-1;
   if (i < 1)
      {
         emas[i][0] = price;
         emas[i][1] = price;
         emas[i][2] = price;
         emas[i][3] = price;
         emas[i][4] = price;
         emas[i][5] = price;
      }
   else
      {
         emas[i][0] = emas[i-1][0]+alpha*(price     -emas[i-1][0]);
         emas[i][1] = emas[i-1][1]+alpha*(emas[i][0]-emas[i-1][1]);
         emas[i][2] = emas[i-1][2]+alpha*(emas[i][1]-emas[i-1][2]);
         emas[i][3] = emas[i-1][3]+alpha*(emas[i][2]-emas[i-1][3]);
         emas[i][4] = emas[i-1][4]+alpha*(emas[i][3]-emas[i-1][4]);
         emas[i][5] = emas[i-1][5]+alpha*(emas[i][4]-emas[i-1][5]);
      }
   return(c1*emas[i][5] + c2*emas[i][4] + c3*emas[i][3] + c4*emas[i][2]);
}